/*
 * Decompiled with CFR 0.152.
 */
package com.arcaryx.cobblemonintegrations.data;

import com.arcaryx.cobblemonintegrations.data.EvoItem;
import com.arcaryx.cobblemonintegrations.data.PokemonDrop;
import com.cobblemon.mod.common.api.drop.ItemDropEntry;
import com.cobblemon.mod.common.api.pokemon.PokemonProperties;
import com.cobblemon.mod.common.api.pokemon.PokemonSpecies;
import com.cobblemon.mod.common.api.pokemon.evolution.Evolution;
import com.cobblemon.mod.common.pokemon.FormData;
import com.cobblemon.mod.common.pokemon.Species;
import com.cobblemon.mod.common.pokemon.evolution.variants.ItemInteractionEvolution;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0013\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0004\u00a2\u0006\u0004\b\u0010\u0010\u0007J'\u0010\u0013\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u001e\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0017\u00a8\u0006\u0019"}, d2={"Lcom/arcaryx/cobblemonintegrations/data/DataSync;", "", "<init>", "()V", "", "Lcom/arcaryx/cobblemonintegrations/data/PokemonDrop;", "getPokemonDrops", "()Ljava/util/List;", "Lcom/cobblemon/mod/common/pokemon/Species;", "species", "Lcom/cobblemon/mod/common/pokemon/FormData;", "form", "", "addDropsToComputed", "(Lcom/cobblemon/mod/common/pokemon/Species;Lcom/cobblemon/mod/common/pokemon/FormData;)V", "Lcom/arcaryx/cobblemonintegrations/data/EvoItem;", "getEvoItems", "Lcom/cobblemon/mod/common/pokemon/evolution/variants/ItemInteractionEvolution;", "evolution", "addEvoItemsToComputed", "(Lcom/cobblemon/mod/common/pokemon/Species;Lcom/cobblemon/mod/common/pokemon/FormData;Lcom/cobblemon/mod/common/pokemon/evolution/variants/ItemInteractionEvolution;)V", "", "computedDrops", "Ljava/util/List;", "computedEvoItems", "cobblemonintegrations-common-1.21.1"})
@SourceDebugExtension(value={"SMAP\nDataSync.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataSync.kt\ncom/arcaryx/cobblemonintegrations/data/DataSync\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,76:1\n1#2:77\n808#3,11:78\n1557#3:89\n1628#3,3:90\n*S KotlinDebug\n*F\n+ 1 DataSync.kt\ncom/arcaryx/cobblemonintegrations/data/DataSync\n*L\n29#1:78,11\n29#1:89\n29#1:90,3\n*E\n"})
public final class DataSync {
    @NotNull
    public static final DataSync INSTANCE = new DataSync();
    @Nullable
    private static List<PokemonDrop> computedDrops;
    @Nullable
    private static List<EvoItem> computedEvoItems;

    private DataSync() {
    }

    @NotNull
    public final List<PokemonDrop> getPokemonDrops() {
        if (computedDrops == null) {
            computedDrops = new ArrayList();
            for (Species species : PokemonSpecies.INSTANCE.getSpecies()) {
                Collection collection;
                Collection collection2 = species.getForms();
                if (collection2.isEmpty()) {
                    boolean bl = false;
                    collection = CollectionsKt.listOf((Object)species.getStandardForm());
                } else {
                    collection = collection2;
                }
                List forms = (List)collection;
                for (FormData form : forms) {
                    this.addDropsToComputed(species, form);
                }
            }
        }
        List<PokemonDrop> list = computedDrops;
        Intrinsics.checkNotNull(list);
        return list;
    }

    /*
     * WARNING - void declaration
     */
    private final void addDropsToComputed(Species species, FormData form) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = form.getDrops().getEntries();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof ItemDropEntry)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void drop;
            ItemDropEntry itemDropEntry = (ItemDropEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            IntRange intRange = drop.getQuantityRange();
            if (intRange == null) {
                intRange = new IntRange(drop.getQuantity(), drop.getQuantity());
            }
            IntRange range = intRange;
            float chance = drop.getPercentage() / 100.0f;
            class_2960 class_29602 = drop.getItem();
            Intrinsics.checkNotNullExpressionValue((Object)class_29602, (String)"<get-item>(...)");
            collection.add(new PokemonDrop.ItemDrop(class_29602, chance, range));
        }
        List itemDrops = (List)destination$iv$iv;
        if (!((Collection)itemDrops).isEmpty()) {
            List<PokemonDrop> list = computedDrops;
            Intrinsics.checkNotNull(list);
            list.add(new PokemonDrop(species.getResourceIdentifier(), form.getName(), itemDrops));
        }
    }

    @NotNull
    public final List<EvoItem> getEvoItems() {
        if (computedEvoItems == null) {
            computedEvoItems = new ArrayList();
            for (Species species : PokemonSpecies.INSTANCE.getSpecies()) {
                Collection collection;
                Collection collection2 = species.getForms();
                if (collection2.isEmpty()) {
                    boolean bl = false;
                    collection = CollectionsKt.listOf((Object)species.getStandardForm());
                } else {
                    collection = collection2;
                }
                List forms = (List)collection;
                for (FormData form : forms) {
                    for (Evolution evolution : form.getEvolutions()) {
                        if (!(evolution instanceof ItemInteractionEvolution)) continue;
                        this.addEvoItemsToComputed(species, form, (ItemInteractionEvolution)evolution);
                    }
                }
            }
        }
        List<EvoItem> list = computedEvoItems;
        Intrinsics.checkNotNull(list);
        return list;
    }

    private final void addEvoItemsToComputed(Species species, FormData form, ItemInteractionEvolution evolution) {
        block2: {
            PokemonProperties result = evolution.getResult();
            result.updateAspects();
            String string = result.getSpecies();
            if (string == null) break block2;
            String speciesName = string;
            boolean bl = false;
            Species species2 = PokemonSpecies.INSTANCE.getByName(speciesName);
            if (species2 != null) {
                Species pokemonSpecies = species2;
                boolean bl2 = false;
                List<EvoItem> list = computedEvoItems;
                if (list != null) {
                    list.add(new EvoItem(species.getResourceIdentifier(), CollectionsKt.toSet((Iterable)form.getAspects()), evolution, null, pokemonSpecies.getResourceIdentifier(), result.getAspects()));
                }
            }
        }
    }
}

